/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap.holders;

import java.time.Duration;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;

public class SimpleOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final V value;

    protected SimpleOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, boolean evictionAdvice) {
        super(id, creationTime, expirationTime, evictionAdvice);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
    }

    public SimpleOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, boolean evictionAdvice, long now, Duration expiration) {
        super(valueHolder.getId(), valueHolder.creationTime(), valueHolder.expirationTime(), evictionAdvice);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
        this.accessed(now, expiration);
    }

    public SimpleOnHeapValueHolder(V value, long creationTime, boolean evictionAdvice) {
        this(value, creationTime, -1L, evictionAdvice);
    }

    public SimpleOnHeapValueHolder(V value, long creationTime, long expirationTime, boolean evictionAdvice) {
        this(-1L, value, creationTime, expirationTime, evictionAdvice);
    }

    @Override
    public V get() {
        return this.value;
    }
}

