/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.IOStatistics;
import java.io.File;

public class NIOStatistics
implements IOStatistics {
    private final long available;
    private final long totalUsed;
    private final long totalWrites;
    private final long totalReads;
    private final long dead;

    NIOStatistics(File directory, long used, long dead, long written, long reads) {
        this.available = directory.getUsableSpace();
        this.totalUsed = used;
        this.totalWrites = written;
        this.totalReads = reads;
        this.dead = dead;
    }

    @Override
    public long getExpiredSize() {
        return this.dead;
    }

    @Override
    public long getLiveSize() {
        return this.totalUsed - this.dead;
    }

    @Override
    public long getTotalAvailable() {
        return this.available;
    }

    @Override
    public long getTotalUsed() {
        return this.totalUsed;
    }

    @Override
    public long getTotalWritten() {
        return this.totalWrites;
    }

    @Override
    public long getTotalRead() {
        return this.totalReads;
    }

    public String toString() {
        return " available: " + this.available + " totalUsed:" + this.totalUsed + " totalWrites:" + this.totalWrites + " totalReads:" + this.totalReads + " dead:" + this.dead;
    }
}

