/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.util.LongLongOrderedDeltaArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerDictionary {
    private static Logger LOG = LoggerFactory.getLogger(MarkerDictionary.class);
    private LongLongOrderedDeltaArray map = new LongLongOrderedDeltaArray(512);
    private int count = 0;

    public void append(long key, long val) {
        if (this.map.isEmpty() || key > this.map.getKey(this.map.size() - 1)) {
            this.map.append(key, val);
            ++this.count;
        } else {
            throw new UnsupportedOperationException(key + " vs " + this.map.getKey(this.map.size() - 1));
        }
    }

    public void clear() {
        this.count = 0;
        this.map.clear();
    }

    public LongLongOrderedDeltaArray.LongLongEntry ceilingEntry(long from) {
        int pos = this.map.binarySearch(from);
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
        }
        if (pos >= 0 && pos < this.map.size()) {
            LongLongOrderedDeltaArray.LongLongEntry ent = this.map.get(pos);
            return ent;
        }
        return null;
    }

    public LongLongOrderedDeltaArray.LongLongEntry floorEntry(long from) {
        int pos = this.map.binarySearch(from);
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
            --pos;
        }
        if (pos >= 0 && pos < this.map.size()) {
            LongLongOrderedDeltaArray.LongLongEntry ent = this.map.get(pos);
            return ent;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public LongLongOrderedDeltaArray.LongLongEntry lastEntry() {
        if (this.map.isEmpty()) {
            return null;
        }
        LongLongOrderedDeltaArray.LongLongEntry ent = this.map.get(this.map.size() - 1);
        return ent;
    }

    public LongLongOrderedDeltaArray.LongLongEntry firstEntry() {
        if (this.map.isEmpty()) {
            return null;
        }
        LongLongOrderedDeltaArray.LongLongEntry ent = this.map.get(0);
        return ent;
    }

    public boolean replace(long key, long value) {
        int pos = this.map.binarySearch(key);
        if (pos >= 0) {
            this.map.update(pos, key, value);
            return true;
        }
        return false;
    }

    public LongLongOrderedDeltaArray.LongLongEntry get(long key) {
        int pos = this.map.binarySearch(key);
        if (pos >= 0) {
            return this.map.get(pos);
        }
        return null;
    }
}

