/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortDataListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortMessageListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import com.fazecast.jSerialComm.android.AndroidPort;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class SerialPort {
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_READ_BLOCKING = 16;
    public static final int TIMEOUT_WRITE_BLOCKING = 256;
    public static final int TIMEOUT_SCANNER = 4096;
    public static final int LISTENING_EVENT_TIMED_OUT = 0;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    public static final int LISTENING_EVENT_BREAK_INTERRUPT = 65536;
    public static final int LISTENING_EVENT_CARRIER_DETECT = 131072;
    public static final int LISTENING_EVENT_CTS = 262144;
    public static final int LISTENING_EVENT_DSR = 524288;
    public static final int LISTENING_EVENT_RING_INDICATOR = 0x100000;
    public static final int LISTENING_EVENT_FRAMING_ERROR = 0x200000;
    public static final int LISTENING_EVENT_FIRMWARE_OVERRUN_ERROR = 0x400000;
    public static final int LISTENING_EVENT_SOFTWARE_OVERRUN_ERROR = 0x800000;
    public static final int LISTENING_EVENT_PARITY_ERROR = 0x1000000;
    public static final int LISTENING_EVENT_PORT_DISCONNECTED = 0x10000000;
    private static final ReentrantLock libraryLock = new ReentrantLock(true);
    private static final String versionString = "2.12.0-ff8a78f-SNAPSHOT";
    private static final String tmpdirAppIdProperty = "fazecast.jSerialComm.appid";
    private static final List<Thread> shutdownHooks = new ArrayList<Thread>();
    private static boolean cleanUpOnShutdown = false;
    private static boolean allowOpenForEnumeration = false;
    private static boolean isAndroidDelete = false;
    private static boolean isWindows = false;
    private static boolean isAndroid = false;
    private static volatile boolean isShuttingDown = false;
    private AndroidPort androidPort = null;
    private volatile long portHandle = 0L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile int sendDeviceQueueSize = 4096;
    private volatile int receiveDeviceQueueSize = 4096;
    private volatile int vendorID;
    private volatile int productID;
    private volatile int safetySleepTimeMS = 200;
    private volatile int rs485DelayBefore = 0;
    private volatile int rs485DelayAfter = 0;
    private volatile byte xonStartChar = (byte)17;
    private volatile byte xoffStopChar = (byte)19;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String comPort;
    private volatile String friendlyName;
    private volatile String portDescription;
    private volatile String portLocation;
    private volatile String serialNumber;
    private volatile String manufacturer;
    private volatile String deviceDriver;
    private volatile boolean eventListenerRunning = false;
    private volatile boolean disableConfig = false;
    private volatile boolean disableExclusiveLock = false;
    private volatile boolean rs485Mode = false;
    private volatile boolean rs485ActiveHigh = true;
    private volatile boolean rs485RxDuringTx = false;
    private volatile boolean rs485EnableTermination = false;
    private volatile boolean isRtsEnabled = true;
    private volatile boolean isDtrEnabled = true;
    private volatile boolean autoFlushIOBuffers = false;
    private volatile boolean requestElevatedPermissions = false;
    private volatile boolean rs485ModeControlEnabled = true;
    private volatile boolean isPathSymlink = false;
    private final ReentrantLock configurationLock = new ReentrantLock(true);

    private static boolean isSymbolicLink(File file) throws IOException {
        File file2 = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !file2.getCanonicalFile().equals(file2.getAbsoluteFile());
    }

    private static void cleanUpDirectory(File file) throws IOException {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.getName().equals(versionString)) continue;
                SerialPort.cleanUpDirectory(file2.getCanonicalFile());
            }
        }
        if (!file.getName().equals(versionString) && !file.getName().equals("..")) {
            file.delete();
        }
    }

    private static void deleteDirectory(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                SerialPort.deleteDirectory(file2);
            }
        }
        file.delete();
    }

    private static boolean loadNativeLibrary(String string, Vector<String> vector) {
        try {
            System.load(string);
            if (!SerialPort.getNativeLibraryVersion().equals(versionString)) {
                vector.add("Native library at " + string + " has the incorrect version: " + SerialPort.getNativeLibraryVersion() + ", Expected " + versionString);
                SerialPort.uninitializeLibrary();
                return false;
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            vector.add(unsatisfiedLinkError.getMessage());
            return false;
        }
        catch (Exception exception) {
            vector.add(exception.getMessage());
            return false;
        }
    }

    public final String toString() {
        return this.getPortDescription();
    }

    public static String getVersion() {
        return versionString;
    }

    public static void addShutdownHook(Thread thread) {
        libraryLock.lock();
        try {
            shutdownHooks.add(thread);
        }
        finally {
            libraryLock.unlock();
        }
    }

    public static boolean setAndroidContext(Object object) {
        if (isAndroid) {
            try {
                if (Class.forName("android.app.Application").isInstance(object)) {
                    AndroidPort.setAndroidContext(object);
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void autoCleanupAtShutdown() {
        cleanUpOnShutdown = true;
    }

    public static void allowPortOpenForEnumeration() {
        allowOpenForEnumeration = true;
    }

    public static SerialPort[] getCommPorts() {
        libraryLock.lock();
        try {
            SerialPort[] serialPortArray = isAndroid ? AndroidPort.getCommPortsNative() : SerialPort.getCommPortsNative();
            return serialPortArray;
        }
        finally {
            libraryLock.unlock();
        }
    }

    public static SerialPort getCommPort(String string) throws SerialPortInvalidPortException {
        if (isAndroid) {
            return null;
        }
        libraryLock.lock();
        String string2 = string;
        try {
            if (string.startsWith("~" + File.separator)) {
                string = System.getProperty("user.home", "/tmp") + string.substring(1);
            }
            if (isWindows) {
                string = "\\\\.\\" + string.substring(string.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(string))) {
                string = new File(string).getCanonicalPath();
            } else if (!new File(string).exists()) {
                string = "/dev/" + string;
                if (!new File(string).exists()) {
                    string = "/dev/" + string.substring(string.lastIndexOf(47) + 1);
                }
                if (!new File(string).exists()) {
                    throw new IOException();
                }
            }
            SerialPort serialPort = new SerialPort();
            serialPort.comPort = string;
            serialPort.productID = -1;
            serialPort.vendorID = -1;
            serialPort.friendlyName = "User-Specified Port";
            serialPort.portDescription = "User-Specified Port";
            serialPort.serialNumber = "Unknown";
            serialPort.manufacturer = "Unknown";
            serialPort.deviceDriver = "Unknown";
            serialPort.portLocation = "0-0";
            serialPort.retrievePortDetails();
            SerialPort serialPort2 = serialPort;
            return serialPort2;
        }
        catch (Exception exception) {
            throw new SerialPortInvalidPortException("Unable to create a serial port object from the invalid port descriptor: " + string2, exception);
        }
        finally {
            libraryLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public final boolean openPort(int var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean openPort(int n) {
        return this.openPort(n, this.sendDeviceQueueSize, this.receiveDeviceQueueSize);
    }

    public final boolean openPort() {
        return this.openPort(0);
    }

    public final boolean closePort() {
        this.configurationLock.lock();
        try {
            if (this.serialEventListener != null) {
                this.serialEventListener.stopListening();
            }
            if (this.portHandle != 0L) {
                this.portHandle = this.androidPort != null ? this.androidPort.closePortNative() : this.closePortNative(this.portHandle);
            }
            boolean bl = this.portHandle == 0L;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean isOpen() {
        this.configurationLock.lock();
        try {
            boolean bl = this.portHandle != 0L;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void disablePortConfiguration() {
        this.configurationLock.lock();
        try {
            this.disableConfig = true;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void disableExclusiveLock() {
        this.configurationLock.lock();
        try {
            this.disableExclusiveLock = true;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void allowElevatedPermissionsRequest() {
        this.configurationLock.lock();
        try {
            this.requestElevatedPermissions = true;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final int getLastErrorLocation() {
        return this.androidPort != null ? this.androidPort.getLastErrorLocation() : this.getLastErrorLocation(this.portHandle);
    }

    public final int getLastErrorCode() {
        return this.androidPort != null ? this.androidPort.getLastErrorCode() : this.getLastErrorCode(this.portHandle);
    }

    private static native void uninitializeLibrary();

    private static native SerialPort[] getCommPortsNative();

    private static native String getNativeLibraryVersion();

    private native void retrievePortDetails();

    private native long openPortNative();

    private native long closePortNative(long var1);

    private native boolean configPort(long var1);

    private native boolean flushRxTxBuffers(long var1);

    private native int waitForEvent(long var1);

    private native int bytesAvailable(long var1);

    private native int bytesAwaitingWrite(long var1);

    private native int readBytes(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native int writeBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private native void setEventListeningStatus(long var1, boolean var3);

    private native boolean setBreak(long var1);

    private native boolean clearBreak(long var1);

    private native boolean setRTS(long var1);

    private native boolean clearRTS(long var1);

    private native boolean setDTR(long var1);

    private native boolean clearDTR(long var1);

    private native boolean setDTRandRTS(long var1, boolean var3, boolean var4);

    private native boolean getCTS(long var1);

    private native boolean getDSR(long var1);

    private native boolean getDCD(long var1);

    private native boolean getDTR(long var1);

    private native boolean getRTS(long var1);

    private native boolean getRI(long var1);

    private native void quickConfig(long var1, int var3, int var4, int var5);

    private native int getLastErrorLocation(long var1);

    private native int getLastErrorCode(long var1);

    public final int bytesAvailable() {
        return this.portHandle != 0L ? (this.androidPort != null ? this.androidPort.bytesAvailable() : this.bytesAvailable(this.portHandle)) : -1;
    }

    public final int bytesAwaitingWrite() {
        return this.portHandle != 0L ? (this.androidPort != null ? this.androidPort.bytesAwaitingWrite() : this.bytesAwaitingWrite(this.portHandle)) : -1;
    }

    public final int readBytes(byte[] byArray, int n, int n2) {
        if (n > byArray.length - n2) {
            return -2;
        }
        return this.portHandle != 0L ? (this.androidPort != null ? this.androidPort.readBytes(byArray, n, n2, this.timeoutMode, this.readTimeout) : this.readBytes(this.portHandle, byArray, n, n2, this.timeoutMode, this.readTimeout)) : -1;
    }

    public final int readBytes(byte[] byArray, int n) {
        return this.readBytes(byArray, n, 0);
    }

    public final int writeBytes(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (n > byArray.length - n2) {
            return -2;
        }
        for (n3 = 0; this.portHandle != 0L && n3 != n; n3 += n4) {
            int n5 = n4 = this.androidPort != null ? this.androidPort.writeBytes(byArray, n - n3, n2 + n3, this.timeoutMode) : this.writeBytes(this.portHandle, byArray, n - n3, n2 + n3, this.timeoutMode);
            if (n4 <= 0) break;
        }
        return this.portHandle != 0L && n3 >= 0 ? n3 : -1;
    }

    public final int writeBytes(byte[] byArray, int n) {
        return this.writeBytes(byArray, n, 0);
    }

    public final int getDeviceWriteBufferSize() {
        return this.sendDeviceQueueSize;
    }

    public final int getDeviceReadBufferSize() {
        return this.receiveDeviceQueueSize;
    }

    public final boolean setBreak() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.setBreak() : this.setBreak(this.portHandle));
    }

    public final boolean clearBreak() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.clearBreak() : this.clearBreak(this.portHandle));
    }

    public final boolean setRTS() {
        this.isRtsEnabled = true;
        return this.androidPort != null ? this.androidPort.setRTS() : this.portHandle == 0L || this.setRTS(this.portHandle);
    }

    public final boolean clearRTS() {
        this.isRtsEnabled = false;
        return this.androidPort != null ? this.androidPort.clearRTS() : this.portHandle == 0L || this.clearRTS(this.portHandle);
    }

    public final boolean setDTR() {
        this.isDtrEnabled = true;
        return this.androidPort != null ? this.androidPort.setDTR() : this.portHandle == 0L || this.setDTR(this.portHandle);
    }

    public final boolean clearDTR() {
        this.isDtrEnabled = false;
        return this.androidPort != null ? this.androidPort.clearDTR() : this.portHandle == 0L || this.clearDTR(this.portHandle);
    }

    public final boolean setDTRandRTS(boolean bl, boolean bl2) {
        this.isDtrEnabled = bl;
        this.isRtsEnabled = bl2;
        return this.androidPort != null ? this.androidPort.setDTRandRTS(bl, bl2) : this.portHandle == 0L || this.setDTRandRTS(this.portHandle, bl, bl2);
    }

    public final boolean getCTS() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getCTS() : this.getCTS(this.portHandle));
    }

    public final boolean getDSR() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getDSR() : this.getDSR(this.portHandle));
    }

    public final boolean getDCD() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getDCD() : this.getDCD(this.portHandle));
    }

    public final boolean getDTR() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getDTR() : this.getDTR(this.portHandle));
    }

    public final boolean getRTS() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getRTS() : this.getRTS(this.portHandle));
    }

    public final boolean getRI() {
        return this.portHandle != 0L && (this.androidPort != null ? this.androidPort.getRI() : this.getRI(this.portHandle));
    }

    private SerialPort() {
    }

    private SerialPort(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, int n2) {
        this.comPort = string;
        this.friendlyName = string2;
        this.portDescription = string3;
        this.portLocation = string4;
        this.serialNumber = string5;
        this.manufacturer = string6;
        this.deviceDriver = string7;
        this.vendorID = n;
        this.productID = n2;
    }

    public final boolean addDataListener(SerialPortDataListener serialPortDataListener) {
        this.configurationLock.lock();
        try {
            if (this.userDataListener != null) {
                boolean bl = false;
                return bl;
            }
            this.userDataListener = serialPortDataListener;
            this.eventFlags = serialPortDataListener.getListeningEvents();
            if ((this.eventFlags & 0x10) > 0) {
                this.eventFlags |= 1;
            }
            SerialPortEventListener serialPortEventListener = this.userDataListener instanceof SerialPortPacketListener ? new SerialPortEventListener(((SerialPortPacketListener)this.userDataListener).getPacketSize()) : (this.serialEventListener = this.userDataListener instanceof SerialPortMessageListener ? new SerialPortEventListener(((SerialPortMessageListener)this.userDataListener).getMessageDelimiter(), ((SerialPortMessageListener)this.userDataListener).delimiterIndicatesEndOfMessage()) : new SerialPortEventListener());
            if (this.portHandle != 0L) {
                if (this.androidPort != null) {
                    this.androidPort.configPort(this);
                } else {
                    this.configPort(this.portHandle);
                }
                this.serialEventListener.startListening();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void flushDataListener() {
        this.configurationLock.lock();
        try {
            if (this.serialEventListener != null) {
                this.serialEventListener.resetBuffers();
            }
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void removeDataListener() {
        this.configurationLock.lock();
        try {
            this.eventFlags = 0;
            if (this.serialEventListener != null) {
                this.serialEventListener.stopListening();
                this.serialEventListener = null;
            }
            this.userDataListener = null;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final InputStream getInputStream() {
        return new SerialPortInputStream(false);
    }

    public final InputStream getInputStreamWithSuppressedTimeoutExceptions() {
        return new SerialPortInputStream(true);
    }

    public final OutputStream getOutputStream() {
        return new SerialPortOutputStream();
    }

    public final boolean flushIOBuffers() {
        this.configurationLock.lock();
        try {
            if (this.portHandle != 0L) {
                boolean bl = this.androidPort != null ? this.androidPort.flushRxTxBuffers() : this.flushRxTxBuffers(this.portHandle);
                return bl;
            }
            this.autoFlushIOBuffers = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setComPortParameters(int n, int n2, int n3, int n4) {
        return this.setComPortParameters(n, n2, n3, n4, this.rs485Mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setComPortParameters(int n, int n2, int n3, int n4, boolean bl) {
        this.configurationLock.lock();
        try {
            this.baudRate = n;
            this.dataBits = n2;
            this.stopBits = n3;
            this.parity = n4;
            this.rs485Mode = bl;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl2 = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setComPortTimeouts(int n, int n2, int n3) {
        this.configurationLock.lock();
        try {
            this.timeoutMode = n;
            if (isWindows) {
                this.readTimeout = n2;
                this.writeTimeout = n3;
            } else {
                this.readTimeout = n2 > 0 && n2 <= 100 ? 100 : Math.round((float)n2 / 100.0f) * 100;
            }
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setBaudRate(int n) {
        this.configurationLock.lock();
        try {
            this.baudRate = n;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setNumDataBits(int n) {
        this.configurationLock.lock();
        try {
            this.dataBits = n;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setNumStopBits(int n) {
        this.configurationLock.lock();
        try {
            this.stopBits = n;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setFlowControl(int n) {
        this.configurationLock.lock();
        try {
            this.flowControl = n;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean setParity(int n) {
        this.configurationLock.lock();
        try {
            this.parity = n;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final void quickSetConfig(int n, int n2, int n3) {
        if (this.portHandle != 0L) {
            if (this.androidPort != null) {
                this.androidPort.quickConfig(this, n, n2, n3);
            } else {
                this.quickConfig(this.portHandle, n, n2, n3);
            }
        }
        this.dataBits = n;
        this.stopBits = n2;
        this.parity = n3;
    }

    public final boolean setRs485ModeParameters(boolean bl, boolean bl2, int n, int n2) {
        return this.setRs485ModeParameters(bl, bl2, false, false, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setRs485ModeParameters(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2) {
        this.configurationLock.lock();
        try {
            this.rs485Mode = bl;
            this.rs485ActiveHigh = bl2;
            this.rs485EnableTermination = bl3;
            this.rs485RxDuringTx = bl4;
            this.rs485DelayBefore = n;
            this.rs485DelayAfter = n2;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl5 = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl5;
            }
            boolean bl6 = true;
            return bl6;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final boolean disableRs485ModeControl() {
        this.configurationLock.lock();
        try {
            this.rs485ModeControlEnabled = false;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setXonXoffCharacters(byte by, byte by2) {
        this.configurationLock.lock();
        try {
            this.xonStartChar = by;
            this.xoffStopChar = by2;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.androidPort != null ? this.androidPort.configPort(this) : this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public final String getDescriptivePortName() {
        return this.friendlyName.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final String getSystemPortPath() {
        return this.comPort;
    }

    public final String getPortDescription() {
        return this.portDescription.trim();
    }

    public final String getPortLocation() {
        return this.portLocation;
    }

    public final String getDeviceDriver() {
        return this.deviceDriver;
    }

    public final int getVendorID() {
        return this.vendorID;
    }

    public final int getProductID() {
        return this.productID;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final boolean isSymlink() {
        return this.isPathSymlink;
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        try {
            String[] stringArray;
            String string;
            String string2;
            String string3 = System.getProperty("jSerialComm.library.path", "");
            String string4 = System.getProperty("os.name", "").toLowerCase();
            String string5 = System.getProperty("os.arch", "").toLowerCase();
            final File file = new File(System.getProperty("java.io.tmpdir", string4.contains("win") ? "C:\\Temp" : "/tmp"), "jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, ".") + File.separator + versionString).getCanonicalFile();
            final File file2 = new File(System.getProperty("user.home", string4.contains("win") ? "C:\\Temp" : "/tmp"), ".jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, ".") + File.separator + versionString).getCanonicalFile();
            boolean bl = System.getProperty("jSerialComm.library.randomizeNativeName", "false").equalsIgnoreCase("true");
            SerialPort.cleanUpDirectory(new File(file, ".."));
            SerialPort.cleanUpDirectory(new File(file2, ".."));
            if (System.getProperty("java.vm.vendor", "").toLowerCase().contains("android")) {
                isAndroidDelete = true;
                string2 = "Android";
                string = "libjSerialComm.so";
                stringArray = new String[]{"arm64-v8a", "armeabi-v7a", "x86_64", "x86"};
            } else if (string4.contains("win")) {
                isWindows = true;
                string2 = "Windows";
                string = "jSerialComm.dll";
                stringArray = !System.getProperty("os.arch_full", "").isEmpty() ? new String[]{System.getProperty("os.arch_full").toLowerCase()} : (string5.contains("86") || string5.contains("amd") ? new String[]{"x86_64", "x86", "aarch64", "armv7"} : new String[]{"aarch64", "armv7", "x86_64", "x86"});
            } else if (string4.contains("mac")) {
                string2 = "OSX";
                string = "libjSerialComm.jnilib";
                stringArray = new String[]{"aarch64", "x86_64", "x86"};
            } else if (string4.contains("sunos") || string4.contains("solaris")) {
                string2 = "Solaris";
                string = "libjSerialComm.so";
                stringArray = new String[]{"sparcv9_64", "sparcv8plus_32", "x86_64", "x86"};
            } else if (string4.contains("freebsd")) {
                string2 = "FreeBSD";
                string = "libjSerialComm.so";
                stringArray = new String[]{"arm64", "x86_64", "x86"};
            } else if (string4.contains("openbsd")) {
                string2 = "OpenBSD";
                string = "libjSerialComm.so";
                stringArray = new String[]{"amd64", "x86"};
            } else if (string4.contains("nix") || string4.contains("nux")) {
                string2 = "Linux";
                string = "libjSerialComm.so";
                stringArray = !System.getProperty("os.arch_full", "").isEmpty() ? new String[]{System.getProperty("os.arch_full").toLowerCase()} : (string5.contains("86") || string5.contains("amd") ? new String[]{"x86_64", "x86", "armv5", "armv6hf", "armv7hf", "armv8_64", "armv8_32", "ppc64le"} : new String[]{"armv5", "armv6hf", "armv7hf", "armv8_64", "x86_64", "armv8_32", "ppc64le", "x86"});
            } else {
                System.err.println("This operating system is not supported by the jSerialComm library.");
                string = null;
                string2 = null;
                stringArray = null;
                System.exit(-1);
            }
            if (!isAndroid) {
                File file3;
                int n;
                boolean bl2 = false;
                Vector<String> vector = new Vector<String>();
                if (!string3.isEmpty()) {
                    for (int i = 0; !bl2 && i < stringArray.length; ++i) {
                        bl2 = SerialPort.loadNativeLibrary(new File(string3, string2 + File.separator + stringArray[i] + File.separator + string).getCanonicalPath(), vector);
                    }
                    if (!bl2) {
                        bl2 = SerialPort.loadNativeLibrary(new File(string3, string).getCanonicalPath(), vector);
                    }
                }
                try {
                    System.loadLibrary("jSerialComm");
                    if (SerialPort.getNativeLibraryVersion().equals(versionString)) {
                        bl2 = true;
                    } else {
                        vector.add("Native library in system path has the incorrect version: " + SerialPort.getNativeLibraryVersion() + ", Expected " + versionString);
                        SerialPort.uninitializeLibrary();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    vector.add(unsatisfiedLinkError.getMessage());
                }
                catch (Exception exception) {
                    vector.add(exception.getMessage());
                }
                for (n = 0; !bl2 && n < 2; ++n) {
                    file3 = new File(n == 0 ? file : file2, string);
                    bl2 = file3.exists() && SerialPort.loadNativeLibrary(file3.getCanonicalPath(), vector);
                }
                String string6 = bl ? new Date().getTime() + "-" + string : string;
                for (n = 0; !bl2 && n < 2; ++n) {
                    SerialPort.deleteDirectory(new File(n == 0 ? file : file2, "..").getCanonicalFile());
                    file3 = new File(n == 0 ? file : file2, string6);
                    if (!file3.getParentFile().exists() && !file3.getParentFile().mkdirs()) continue;
                    file3.getParentFile().setReadable(true, false);
                    file3.getParentFile().setWritable(true, false);
                    file3.getParentFile().setExecutable(true, false);
                    for (int i = 0; !bl2 && i < stringArray.length; ++i) {
                        InputStream inputStream = SerialPort.class.getResourceAsStream("/" + string2 + "/" + stringArray[i] + "/" + string);
                        if (inputStream == null) continue;
                        try {
                            int n2;
                            file3.delete();
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            byte[] byArray = new byte[4096];
                            while ((n2 = inputStream.read(byArray)) > 0) {
                                fileOutputStream.write(byArray, 0, n2);
                            }
                            fileOutputStream.close();
                            inputStream.close();
                            file3.setReadable(true, false);
                            file3.setWritable(true, false);
                            file3.setExecutable(true, false);
                            vector.add("Loading for arch: " + stringArray[i]);
                            bl2 = SerialPort.loadNativeLibrary(file3.getCanonicalPath(), vector);
                            if (!bl2) continue;
                            vector.add("Successfully loaded!");
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (bl2) continue;
                    file3.delete();
                    if (n <= 0) continue;
                    StringBuilder stringBuilder = new StringBuilder("Cannot load native library. Errors as follows:\n");
                    for (int i = 0; i < vector.size(); ++i) {
                        stringBuilder.append('[').append(i + 1).append("]: ").append(vector.get(i)).append('\n');
                    }
                    throw new UnsatisfiedLinkError(stringBuilder.toString());
                }
            }
            Runtime.getRuntime().addShutdownHook(SerialPortThreadFactory.get().newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Thread thread : shutdownHooks) {
                            thread.start();
                            thread.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    isShuttingDown = true;
                    if (!isAndroid) {
                        SerialPort.uninitializeLibrary();
                    }
                    if (cleanUpOnShutdown) {
                        try {
                            SerialPort.deleteDirectory(new File(file, "..").getCanonicalFile());
                            SerialPort.deleteDirectory(new File(file2, "..").getCanonicalFile());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        private final byte[] byteBuffer = new byte[1];

        @Override
        public final void write(int n) throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            this.byteBuffer[0] = (byte)(n & 0xFF);
            int n2 = SerialPort.this.writeBytes(this.byteBuffer, 1);
            if (n2 < 0) {
                throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
            }
            if (n2 == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }

        @Override
        public final void write(byte[] byArray) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            int n3;
            if (byArray == null) {
                throw new NullPointerException("A null pointer was passed in for the write buffer.");
            }
            if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("The specified write offset plus length extends past the end of the specified buffer.");
            }
            for (int i = 0; i != n2; i += n3) {
                if (SerialPort.this.portHandle == 0L) {
                    throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
                }
                n3 = SerialPort.this.writeBytes(byArray, n2 - i, n + i);
                if (n3 < 0) {
                    throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
                }
                if (n3 != 0) continue;
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        private final boolean timeoutExceptionsSuppressed;
        private final byte[] byteBuffer = new byte[1];

        public SerialPortInputStream(boolean bl) {
            this.timeoutExceptionsSuppressed = bl;
        }

        @Override
        public final int available() throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable();
        }

        @Override
        public final int read() throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            int n = SerialPort.this.readBytes(this.byteBuffer, 1);
            if (n == 0) {
                if (this.timeoutExceptionsSuppressed) {
                    return -1;
                }
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return n < 0 ? -1 : this.byteBuffer[0] & 0xFF;
        }

        @Override
        public final int read(byte[] byArray) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            if (byArray == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (byArray.length == 0) {
                return 0;
            }
            int n = SerialPort.this.readBytes(byArray, byArray.length);
            if (n == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return n;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (byArray == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException("The specified read offset plus length extends past the end of the specified buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (byArray.length == 0 || n2 == 0) {
                return 0;
            }
            int n3 = SerialPort.this.readBytes(byArray, n2, n);
            if (n3 == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return n3;
        }

        @Override
        public final long skip(long l) throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            long l2 = 0L;
            int n = l > 4096L ? 4096 : (int)l;
            byte[] byArray = new byte[n];
            long l3 = 1L;
            for (long i = 0L; l3 > 0L && i < l; i += (long)n) {
                l3 = SerialPort.this.readBytes(byArray, (int)Math.min(l - i, (long)n));
                if (l3 <= 0L) continue;
                l2 += l3;
            }
            return l2;
        }
    }

    private final class SerialPortEventListener {
        private final boolean messageEndIsDelimited;
        private final byte[] dataPacket;
        private final byte[] delimiters;
        private final ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
        private int dataPacketIndex = 0;
        private int delimiterIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener() {
            this.dataPacket = new byte[0];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(int n) {
            this.dataPacket = new byte[n];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(byte[] byArray, boolean bl) {
            this.dataPacket = new byte[0];
            this.delimiters = byArray;
            this.messageEndIsDelimited = bl;
        }

        public final void startListening() {
            if (SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = true;
            this.resetBuffers();
            if (SerialPort.this.androidPort != null) {
                SerialPort.this.androidPort.setEventListeningStatus(true);
            } else {
                SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, true);
            }
            this.serialEventThread = SerialPortThreadFactory.get().newThread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPort.this.eventListenerRunning && !isShuttingDown) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (Exception exception) {
                            SerialPort.this.eventListenerRunning = false;
                            if (SerialPort.this.userDataListener instanceof SerialPortDataListenerWithExceptions) {
                                ((SerialPortDataListenerWithExceptions)SerialPort.this.userDataListener).catchException(exception);
                                continue;
                            }
                            if (!(SerialPort.this.userDataListener instanceof SerialPortMessageListenerWithExceptions)) continue;
                            ((SerialPortMessageListenerWithExceptions)SerialPort.this.userDataListener).catchException(exception);
                        }
                    }
                    if (SerialPort.this.androidPort != null) {
                        SerialPort.this.androidPort.setEventListeningStatus(false);
                    } else {
                        SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, false);
                    }
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = false;
            int n = SerialPort.this.timeoutMode;
            int n2 = SerialPort.this.eventFlags;
            SerialPort.this.timeoutMode = 0;
            SerialPort.this.eventFlags = 0;
            if (SerialPort.this.androidPort != null) {
                SerialPort.this.androidPort.setEventListeningStatus(false);
                SerialPort.this.androidPort.configPort(SerialPort.this);
            } else {
                SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, false);
                SerialPort.this.configPort(SerialPort.this.portHandle);
            }
            try {
                if (!Thread.currentThread().equals(this.serialEventThread)) {
                    do {
                        this.serialEventThread.join(500L);
                        if (!this.serialEventThread.isAlive()) continue;
                        this.serialEventThread.interrupt();
                    } while (this.serialEventThread.isAlive());
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.serialEventThread = null;
            SerialPort.this.timeoutMode = n;
            SerialPort.this.eventFlags = n2;
            if (SerialPort.this.androidPort != null) {
                SerialPort.this.androidPort.configPort(SerialPort.this);
            } else {
                SerialPort.this.configPort(SerialPort.this.portHandle);
            }
        }

        public final void resetBuffers() {
            this.messageBytes.reset();
            this.dataPacketIndex = 0;
            this.delimiterIndex = 0;
        }

        public final void waitForSerialEvent() throws Exception {
            int n = (SerialPort.this.androidPort != null ? SerialPort.this.androidPort.waitForEvent() : SerialPort.this.waitForEvent(SerialPort.this.portHandle)) & SerialPort.this.eventFlags;
            if ((n & 1) > 0 && (SerialPort.this.eventFlags & 0x10) > 0) {
                int n2;
                n &= 0xFFFFFFEE;
                while (SerialPort.this.eventListenerRunning && (n2 = SerialPort.this.bytesAvailable()) > 0) {
                    int n3 = 0;
                    byte[] byArray = new byte[n2];
                    int n4 = SerialPort.this.readBytes(byArray, byArray.length);
                    if (n4 <= 0) continue;
                    if (this.delimiters.length > 0) {
                        int n5 = 0;
                        for (int i = 0; i < n4; ++i) {
                            if (byArray[i] == this.delimiters[this.delimiterIndex]) {
                                byte[] byArray2;
                                if (++this.delimiterIndex != this.delimiters.length) continue;
                                this.messageBytes.write(byArray, n5, 1 + i - n5);
                                byte[] byArray3 = byArray2 = this.messageEndIsDelimited ? this.messageBytes.toByteArray() : Arrays.copyOf(this.messageBytes.toByteArray(), this.messageBytes.size() - this.delimiters.length);
                                if (byArray2.length > 0 && (this.messageEndIsDelimited || this.delimiters[0] == byArray2[0])) {
                                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, byArray2));
                                }
                                n5 = i + 1;
                                this.messageBytes.reset();
                                this.delimiterIndex = 0;
                                if (this.messageEndIsDelimited) continue;
                                this.messageBytes.write(this.delimiters, 0, this.delimiters.length);
                                continue;
                            }
                            if (this.delimiterIndex == 0) continue;
                            this.delimiterIndex = byArray[i] == this.delimiters[0] ? 1 : 0;
                        }
                        this.messageBytes.write(byArray, n5, n4 - n5);
                        continue;
                    }
                    if (this.dataPacket.length == 0) {
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])byArray.clone()));
                        continue;
                    }
                    while (n4 >= this.dataPacket.length - this.dataPacketIndex) {
                        System.arraycopy(byArray, n3, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                        n4 -= this.dataPacket.length - this.dataPacketIndex;
                        n3 += this.dataPacket.length - this.dataPacketIndex;
                        this.dataPacketIndex = 0;
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                    }
                    if (n4 <= 0) continue;
                    System.arraycopy(byArray, n3, this.dataPacket, this.dataPacketIndex, n4);
                    this.dataPacketIndex += n4;
                }
            }
            if (SerialPort.this.eventListenerRunning && !isShuttingDown && n != 0) {
                if ((n & 0x10000000) > 0) {
                    SerialPort.this.eventListenerRunning = false;
                    SerialPortThreadFactory.get().newThread(new Runnable(){

                        @Override
                        public void run() {
                            SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 0x10000000));
                        }
                    }).start();
                } else {
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, n));
                }
            }
        }
    }
}

